CREATE TABLE alertas_reprovacao (
    id INT AUTO_INCREMENT PRIMARY KEY,
    aluno_id INT NOT NULL,
    turma_id INT NOT NULL,
    disciplina_id INT NOT NULL,
    trimestre INT NOT NULL,
    ano_lectivo VARCHAR(10) NOT NULL,
    mensagem TEXT NOT NULL,
    data_alerta TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    resolvido BOOLEAN DEFAULT FALSE, -- Para rastreamento
    UNIQUE KEY uk_aluno_disc_trim (aluno_id, disciplina_id, trimestre, ano_lectivo), -- Garante um único alerta por caso
    FOREIGN KEY (aluno_id) REFERENCES alunos(id) ON DELETE CASCADE,
    FOREIGN KEY (disciplina_id) REFERENCES disciplinas(id) ON DELETE CASCADE
);